/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Chunk;
import dangerzone.Coords;
import dangerzone.CustomPackets;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.Effects;
import dangerzone.InventoryContainer;
import dangerzone.NetworkInputBuffer;
import dangerzone.NetworkOutputBuffer;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.WorldRendererUtils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ColoringBlock;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.items.Items;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;

public class ServerConnection
implements Runnable {
    Socket sock;
    NetworkOutputBuffer objectOutput = null;
    NetworkInputBuffer objectInput = null;
    public volatile int connected = 0;
    public List<Coords> requested_list;
    public static Lock requested_list_lock = new ReentrantLock();
    private Player p;
    public static Lock output_lock = new ReentrantLock();
    private boolean shouldsync = false;
    public List<String> modnames = new ArrayList<String>();
    public volatile boolean waitformodstoload = false;
    public String worldname = null;
    public volatile boolean connectionInProgress = false;
    public long lastaverageloop = 0L;

    public ServerConnection(Player pl, boolean ss) {
        this.p = pl;
        this.shouldsync = ss;
        this.waitformodstoload = ss;
    }

    @Override
    public void run() {
        int id;
        int d;
        Entity ent = null;
        String name = null;
        int packettype = 0;
        this.requested_list = new ArrayList<Coords>();
        try {
            this.sock = DangerZone.start_server ? new Socket("127.0.0.1", DangerZone.server_port) : new Socket(DangerZone.server_address, DangerZone.server_port);
        }
        catch (UnknownHostException e) {
            DangerZone.connection_msg = "Unknown Server.";
            DangerZone.connection_error = 1;
            return;
        }
        catch (IOException e) {
            DangerZone.connection_msg = "Generic Error.";
            DangerZone.connection_error = 1;
            return;
        }
        try {
            this.sock.setReceiveBufferSize(131072);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        try {
            this.sock.setSendBufferSize(65536);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        try {
            this.sock.setTcpNoDelay(true);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        output_lock.lock();
        try {
            this.objectInput = new NetworkInputBuffer(this.sock.getInputStream(), 131072);
            this.objectOutput = new NetworkOutputBuffer(this.sock.getOutputStream(), 256);
            packettype = 86;
            this.objectOutput.writeInt(packettype);
            this.objectOutput.writeString(DangerZone.versionstring);
            this.objectOutput.flush();
            String vs = this.objectInput.readString();
            if (vs == null || !vs.equals(DangerZone.versionstring)) {
                DangerZone.connection_msg = String.format("Server is DZ version %s", vs);
                DangerZone.connection_error = 1;
                return;
            }
            packettype = 0;
            if (this.shouldsync) {
                packettype = 1;
            }
            this.objectOutput.writeInt(packettype);
            this.objectOutput.writeString(this.p.myname);
            this.objectOutput.writeString(DangerZone.crypted_password);
            this.objectOutput.flush();
            if (this.shouldsync) {
                this.sendSkin();
                this.getModNames();
                this.connectionInProgress = true;
                while (this.waitformodstoload) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                d = -5;
                this.objectOutput.writeInt(d);
                this.objectOutput.flush();
                this.reSyncIDs();
                d = -6;
                this.objectOutput.writeInt(d);
                this.objectOutput.flush();
                this.p.myname = this.objectInput.readString();
                this.p.setPetName(this.p.myname);
                System.out.printf("My name from server is: %s\n", this.p.myname);
            }
            if ((packettype = this.objectInput.readInt()) != 0) {
                DangerZone.connection_msg = "Player is an alien!";
                if (packettype == 1) {
                    DangerZone.connection_msg = "Player Name/Password not valid.";
                }
                if (packettype == 2) {
                    DangerZone.connection_msg = "Player banned... Go away.";
                }
                if (packettype == 3) {
                    DangerZone.connection_msg = "Too many players already. Please try later!";
                }
                DangerZone.connection_error = 1;
                return;
            }
            this.readPlayerIntoPlayer(this.p);
            this.p.init();
            id = this.objectInput.readInt();
            if (id <= 0 || id >= DangerZone.max_entities) {
                DangerZone.connection_msg = "Bad Player Entity ID.";
                DangerZone.connection_error = 5;
                return;
            }
            this.p.entityID = id;
        }
        catch (IOException e) {
            DangerZone.connection_msg = "Too many players or other comm failure.";
            DangerZone.connection_error = 1;
            return;
        }
        this.p.toServer = this.sock;
        this.p.server_connection = this;
        this.p.entityID = id;
        this.connected = 1;
        output_lock.unlock();
        DangerZone.entityManager.addEntity(this.p, id);
        System.out.printf("Connected!\n", new Object[0]);
        try {
            while (DangerZone.gameover == 0) {
                float rrh;
                float ryh;
                float rph;
                float rr;
                float ry;
                float rp;
                int eid;
                float fpz;
                float fpy;
                float mz;
                float my;
                float mx;
                double pz;
                double py;
                double px;
                int which;
                float fpx;
                int z;
                int y;
                int x;
                packettype = this.objectInput.readInt();
                ++DangerZone.packets_per_second;
                if (packettype == 134) {
                    Chunk c = new Chunk(0, 0, 0, 0);
                    this.receiveChunk(c);
                    DangerZone.world.chunkcache.addCacheChunk(c);
                    requested_list_lock.lock();
                    boolean found = true;
                    block17: while (found) {
                        found = false;
                        Iterator<Coords> ii = this.requested_list.iterator();
                        while (ii.hasNext()) {
                            Coords cl = ii.next();
                            if (cl.d != c.dimension || cl.x != c.chunkX || cl.z != c.chunkZ) continue;
                            ii.remove();
                            found = true;
                            continue block17;
                        }
                    }
                    requested_list_lock.unlock();
                    continue;
                }
                if (packettype == 133) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    y = this.objectInput.readInt();
                    z = this.objectInput.readInt();
                    id = this.objectInput.readShort();
                    short meta = this.objectInput.readShort();
                    DangerZone.world.chunkcache.setBlockSilent(d, x, y, z, id, meta);
                    continue;
                }
                if (packettype == 177) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    z = this.objectInput.readInt();
                    ArrayList<String> newowners = null;
                    int nname = this.objectInput.readInt();
                    if (nname > 0) {
                        newowners = new ArrayList<String>();
                        while (nname > 0) {
                            newowners.add(this.objectInput.readString());
                            --nname;
                        }
                    }
                    DangerZone.world.chunkcache.setChunkMeta(d, x << 4, z << 4, newowners);
                    continue;
                }
                if (packettype == 128) {
                    DangerZone.world.timetimer = d = this.objectInput.readInt();
                    DangerZone.world.lengthOfDay = d = this.objectInput.readInt();
                    this.lastaverageloop = this.objectInput.readLong();
                    this.respondtotime();
                    continue;
                }
                if (packettype == 161) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    this.p.setVarInt(d, x);
                    continue;
                }
                if (packettype == 163) {
                    d = this.objectInput.readInt();
                    fpx = this.objectInput.readFloat();
                    this.p.setVarFloat(d, fpx);
                    continue;
                }
                if (packettype == 168) {
                    d = this.objectInput.readInt();
                    String ss = this.objectInput.readString();
                    this.p.setVarString(d, ss);
                    continue;
                }
                if (packettype == 162) {
                    d = this.objectInput.readInt();
                    if (d > 0) {
                        ent = DangerZone.entityManager.findEntityByID(d);
                        if (ent == null) continue;
                        ent.setVarInt(10, this.p.entityID);
                        this.p.setVarInt(11, d);
                        if (!ent.sit_when_riding) continue;
                        this.p.setSitting(true);
                        continue;
                    }
                    this.p.setVarInt(10, 0);
                    this.p.setVarInt(11, 0);
                    this.p.setSitting(false);
                    continue;
                }
                if (packettype == 167) {
                    Effects ef = new Effects();
                    ef.effect = this.objectInput.readInt();
                    ef.duration = this.objectInput.readInt();
                    ef.amplitude = this.objectInput.readFloat();
                    DangerZone.player.addEffect(ef);
                    continue;
                }
                if (packettype == 153) {
                    String s = this.objectInput.readString();
                    DangerZone.chatgui.receiveMessage(s);
                    if (DangerZone.current_gui != null) continue;
                    DangerZone.messagestring = s;
                    DangerZone.messagetimer = 180;
                    continue;
                }
                if (packettype == 169) {
                    String s = this.objectInput.readString();
                    DangerZone.soundmangler.playThisMusic(s);
                    continue;
                }
                if (packettype == 156) {
                    String s = this.objectInput.readString();
                    DangerZone.commandgui.receiveMessage(s);
                    if (DangerZone.current_gui != null) continue;
                    DangerZone.messagestring = s;
                    DangerZone.messagetimer = 180;
                    continue;
                }
                if (packettype == 154) {
                    String s = this.objectInput.readString();
                    which = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    id = this.objectInput.readInt();
                    Utils.spawnParticles(DangerZone.player.world, s, which, d, px, py, pz, id, false);
                    continue;
                }
                if (packettype == 182) {
                    String s = this.objectInput.readString();
                    which = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    id = this.objectInput.readInt();
                    fpx = this.objectInput.readFloat();
                    Utils.spawnParticlesScaled(DangerZone.player.world, s, which, d, px, py, pz, id, fpx, false);
                    continue;
                }
                if (packettype == 183) {
                    String s = this.objectInput.readString();
                    which = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    mx = this.objectInput.readFloat();
                    my = this.objectInput.readFloat();
                    mz = this.objectInput.readFloat();
                    id = this.objectInput.readInt();
                    fpx = this.objectInput.readFloat();
                    fpy = this.objectInput.readFloat();
                    fpz = this.objectInput.readFloat();
                    Utils.spawnParticlesScaledWithDirection(DangerZone.player.world, s, which, d, px, py, pz, mx, my, mz, id, fpx, fpy, fpz, false);
                    continue;
                }
                if (packettype == 145) {
                    d = this.objectInput.readInt();
                    ent = DangerZone.entityManager.findEntityByID(d);
                    if (ent == null) continue;
                    ent.deadflag = true;
                    ent.doDeathAnimation();
                    continue;
                }
                if (packettype == 138) {
                    d = this.objectInput.readInt();
                    if (d == this.p.entityID || (ent = DangerZone.entityManager.findEntityByID(d)) == null || ent.deadflag || ent.isDying()) continue;
                    DangerZone.entityManager.removeEntityByID(d);
                    continue;
                }
                if (packettype == 149) {
                    d = this.objectInput.readInt();
                    fpx = this.objectInput.readFloat();
                    ent = DangerZone.entityManager.findEntityByID(d);
                    if (ent == null) continue;
                    ent.setHealth(fpx);
                    ent.doHurtAnimation();
                    continue;
                }
                if (packettype == 166) {
                    d = this.objectInput.readInt();
                    this.p.setGameMode(d);
                    if (d == 2) {
                        DangerZone.messagestring = DangerZone.ghost_string;
                    }
                    if (d == 0) {
                        DangerZone.messagestring = DangerZone.survival_string;
                    }
                    if (d == 1) {
                        DangerZone.messagestring = DangerZone.creative_string;
                    }
                    if (d == 3) {
                        DangerZone.messagestring = DangerZone.limbo_string;
                    }
                    DangerZone.messagetimer = 100;
                    continue;
                }
                if (packettype == 180) {
                    d = this.objectInput.readInt();
                    this.p.setGameDifficulty(d);
                    if (d == 0) {
                        DangerZone.messagestring = "Difficulty: Normal";
                    }
                    if (d == -1) {
                        DangerZone.messagestring = "Difficulty: Easy";
                    }
                    if (d == -2) {
                        DangerZone.messagestring = "Difficulty: Girly";
                    }
                    if (d == 1) {
                        DangerZone.messagestring = "Difficulty: Hard";
                    }
                    if (d == 2) {
                        DangerZone.messagestring = "Difficulty: Brutal";
                    }
                    DangerZone.messagetimer = 100;
                    continue;
                }
                if (packettype == 184) {
                    d = this.objectInput.readInt();
                    if (d < 8 || d > 24) continue;
                    DangerZone.renderdistance = d;
                    continue;
                }
                if (packettype == 151) {
                    fpx = this.objectInput.readFloat();
                    fpy = this.objectInput.readFloat();
                    fpz = this.objectInput.readFloat();
                    this.p.motionx = fpx;
                    this.p.motiony = fpy;
                    this.p.motionz = fpz;
                    continue;
                }
                if (packettype == 165) {
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    this.p.posx = px;
                    this.p.posy = py;
                    this.p.posz = pz;
                    fpx = this.objectInput.readFloat();
                    fpy = this.objectInput.readFloat();
                    fpz = this.objectInput.readFloat();
                    this.p.motionx = fpx;
                    this.p.motiony = fpy;
                    this.p.motionz = fpz;
                    fpx = this.objectInput.readFloat();
                    fpy = this.objectInput.readFloat();
                    this.p.rotation_yaw = fpx;
                    this.p.rotation_yaw_head = 360.0f - (fpy + 180.0f) % 360.0f;
                    this.p.fallcount = 0;
                    continue;
                }
                if (packettype == 159) {
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    DangerZone.new_posx = px;
                    DangerZone.new_posy = py;
                    DangerZone.new_posz = pz;
                    DangerZone.new_dimension = d;
                    continue;
                }
                if (packettype == 181) continue;
                if (packettype == 147) {
                    InventoryContainer ic;
                    which = this.objectInput.readInt();
                    int slot = this.objectInput.readInt();
                    int bid = this.objectInput.readInt();
                    int iid = this.objectInput.readInt();
                    int count = this.objectInput.readInt();
                    int uses = this.objectInput.readInt();
                    String inmeta = this.objectInput.readString();
                    if (count == 0) {
                        ic = null;
                    } else {
                        int mlength;
                        int atcount;
                        ic = new InventoryContainer();
                        ic.bid = bid;
                        ic.iid = iid;
                        ic.count = count;
                        ic.currentuses = uses;
                        ic.icmeta = inmeta;
                        if (ic.count == 1 && ic.bid == 0 && ic.iid != 0 && (atcount = this.objectInput.readInt()) > 0) {
                            int i = 0;
                            while (i < atcount) {
                                int attype = this.objectInput.readInt();
                                int atval = this.objectInput.readInt();
                                ic.addAttribute(attype, atval);
                                ++i;
                            }
                        }
                        if ((mlength = this.objectInput.readInt()) > 0) {
                            ic.moreInventory = new InventoryContainer[mlength];
                            int mix = 0;
                            while (mix < mlength) {
                                ic.moreInventory[mix] = this.readMoreInventory();
                                ++mix;
                            }
                        }
                    }
                    if (which == 0) {
                        this.p.setHotbar(slot, ic);
                        continue;
                    }
                    if (which == 1) {
                        this.p.setInventory(slot, ic);
                        continue;
                    }
                    if (which == 2) {
                        this.p.setArmor(slot, ic);
                        continue;
                    }
                    this.p.setVarInventory(slot, ic);
                    continue;
                }
                if (packettype == 148) {
                    eid = this.objectInput.readInt();
                    which = this.objectInput.readInt();
                    int what = this.objectInput.readInt();
                    ent = DangerZone.entityManager.findEntityByID(eid);
                    if (ent == null || !(ent instanceof Player) || which != 0 || what != 0 || ent == DangerZone.player) continue;
                    Player pp = (Player)ent;
                    pp.armdir = 1;
                    continue;
                }
                if (packettype == 173) {
                    DangerZone.doDeathGUI = true;
                    continue;
                }
                if (packettype == 179) {
                    this.p.kills = this.objectInput.readInt();
                    this.p.deaths = this.objectInput.readInt();
                    this.p.damage_taken = this.objectInput.readDouble();
                    this.p.damage_dealt = this.objectInput.readDouble();
                    this.p.blocks_broken = this.objectInput.readInt();
                    this.p.blocks_placed = this.objectInput.readInt();
                    this.p.blocks_colored = this.objectInput.readInt();
                    this.p.crafted = this.objectInput.readInt();
                    this.p.bought = this.objectInput.readInt();
                    this.p.sold = this.objectInput.readInt();
                    this.p.broken = this.objectInput.readInt();
                    this.p.traveled = this.objectInput.readInt();
                    this.p.morphs = this.objectInput.readInt();
                    this.p.teleports = this.objectInput.readInt();
                    this.p.eaten = this.objectInput.readInt();
                    this.p.roachstomps = this.objectInput.readInt();
                    this.p.hard_landings = this.objectInput.readInt();
                    this.p.flights = this.objectInput.readInt();
                    this.p.spells = this.objectInput.readInt();
                    continue;
                }
                if (packettype == 144) {
                    eid = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    mx = this.objectInput.readFloat();
                    my = this.objectInput.readFloat();
                    mz = this.objectInput.readFloat();
                    rp = this.objectInput.readFloat();
                    ry = this.objectInput.readFloat();
                    rr = this.objectInput.readFloat();
                    rph = this.objectInput.readFloat();
                    ryh = this.objectInput.readFloat();
                    rrh = this.objectInput.readFloat();
                    float rpm = this.objectInput.readFloat();
                    float rym = this.objectInput.readFloat();
                    float rrm = this.objectInput.readFloat();
                    int dead = this.objectInput.readInt();
                    ent = DangerZone.entityManager.findEntityByID(eid);
                    if (ent != null && d == DangerZone.player.dimension) {
                        if (eid != DangerZone.player.entityID) {
                            ent.diff_ticker = 6;
                            ent.diff_posx = (float)(px - ent.posx);
                            ent.diff_posy = (float)(py - ent.posy);
                            ent.diff_posz = (float)(pz - ent.posz);
                            ent.diff_rotpitch = this.angdiff(rp, ent.rotation_pitch);
                            ent.diff_rotyaw = this.angdiff(ry, ent.rotation_yaw);
                            ent.diff_rotroll = this.angdiff(rr, ent.rotation_roll);
                            ent.diff_rotpitchh = this.angdiff(rph, ent.rotation_pitch_head);
                            ent.diff_rotyawh = this.angdiff(ryh, ent.rotation_yaw_head);
                            ent.diff_rotrollh = this.angdiff(rrh, ent.rotation_roll_head);
                            ent.dimension = d;
                            ent.motionx = mx;
                            ent.motiony = my;
                            ent.motionz = mz;
                            ent.rotation_pitch_motion = rpm;
                            ent.rotation_yaw_motion = rym;
                            ent.rotation_roll_motion = rrm;
                        }
                        ent.deadflag = dead != 0;
                        this.readVarsIntoEntity(ent);
                        ent.stray_entity_ticker = 0;
                        continue;
                    }
                    this.readVarsIntoNull();
                    if (d != DangerZone.player.dimension) continue;
                    double d1 = DangerZone.player.posx - px;
                    double d2 = DangerZone.player.posy - py;
                    double d3 = DangerZone.player.posz - pz;
                    if (!((d1 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3)) < (double)(DangerZone.renderdistance * 16)) || eid == DangerZone.player.entityID) continue;
                    this.whatIsThisEntity(eid);
                    continue;
                }
                if (packettype == 146) {
                    name = this.objectInput.readString();
                    id = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    rp = this.objectInput.readFloat();
                    ry = this.objectInput.readFloat();
                    rr = this.objectInput.readFloat();
                    rph = this.objectInput.readFloat();
                    ryh = this.objectInput.readFloat();
                    rrh = this.objectInput.readFloat();
                    mx = this.objectInput.readFloat();
                    my = this.objectInput.readFloat();
                    mz = this.objectInput.readFloat();
                    double d1 = DangerZone.player.posx - px;
                    double d2 = DangerZone.player.posy - py;
                    double d3 = DangerZone.player.posz - pz;
                    if ((d1 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3)) < (double)(DangerZone.renderdistance * 16) && d == DangerZone.player.dimension) {
                        ent = Entities.spawnEntityByName(name, DangerZone.world);
                        if (ent != null) {
                            ent.entityID = id;
                            ent.dimension = d;
                            ent.posx = px;
                            ent.posy = py;
                            ent.posz = pz;
                            ent.rotation_pitch = rp;
                            ent.rotation_yaw = ry;
                            ent.rotation_roll = rr;
                            ent.rotation_pitch_head = rph;
                            ent.rotation_yaw_head = ryh;
                            ent.rotation_roll_head = rrh;
                            ent.motionx = mx;
                            ent.motiony = my;
                            ent.motionz = mz;
                            this.readVarsIntoEntity(ent);
                            if (ent instanceof Player) {
                                this.getSkinData(ent);
                            }
                            ent.init();
                            DangerZone.entityManager.addEntity(ent, id);
                            if (id != DangerZone.player.entityID) continue;
                            System.out.printf("??spawn entity for self\n", new Object[0]);
                            continue;
                        }
                        this.readVarsIntoNull();
                        continue;
                    }
                    this.readVarsIntoNull();
                    continue;
                }
                if (packettype == 150) {
                    name = this.objectInput.readString();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readDouble();
                    py = this.objectInput.readDouble();
                    pz = this.objectInput.readDouble();
                    float vol = this.objectInput.readFloat();
                    float freq = this.objectInput.readFloat();
                    if (d != DangerZone.player.dimension) continue;
                    DangerZone.soundmangler.playSound(name, vol, freq, d, px, py, pz);
                    continue;
                }
                if (packettype == 152) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    y = this.objectInput.readInt();
                    z = this.objectInput.readInt();
                    float lv = WorldRendererUtils.getTotalLightAt(DangerZone.world, d, x, y, z);
                    this.sendLightResponse(lv);
                    continue;
                }
                if (packettype == 164) {
                    name = this.objectInput.readString();
                    x = this.objectInput.readInt();
                    float[][][] colordata = new float[16][16][4];
                    int i = 0;
                    while (i < 16) {
                        int j = 0;
                        while (j < 16) {
                            int k = 0;
                            while (k < 4) {
                                colordata[i][j][k] = this.objectInput.readFloat();
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.doSaveColoringBlock(name, x, colordata);
                    continue;
                }
                CustomPackets.messageFromServer(packettype, this.objectInput);
            }
        }
        catch (ClassNotFoundException e) {
            DangerZone.gameover = 1;
            return;
        }
    }

    public void getDecoratedChunk(int d, int x, int y, int z) {
        if (this.connected == 0) {
            return;
        }
        if (x < 0 || z < 0) {
            return;
        }
        requested_list_lock.lock();
        long nowtime = System.currentTimeMillis();
        boolean found = true;
        block0: while (found) {
            found = false;
            Iterator<Coords> i = this.requested_list.iterator();
            while (i.hasNext()) {
                Coords c = i.next();
                if (nowtime - c.timer <= 30000L) continue;
                i.remove();
                found = true;
                continue block0;
            }
        }
        boolean addit = true;
        for (Coords c : this.requested_list) {
            if (c.d != d || c.x != x >> 4 || c.z != z >> 4) continue;
            if (nowtime - c.timer > 5000L) {
                c.timer = nowtime;
                addit = false;
                break;
            }
            requested_list_lock.unlock();
            Thread.yield();
            return;
        }
        if (addit) {
            Coords newc = new Coords();
            newc.d = d;
            newc.x = x >> 4;
            newc.y = y;
            newc.z = z >> 4;
            newc.timer = nowtime;
            this.requested_list.add(newc);
        }
        requested_list_lock.unlock();
        int pt = 135;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        output_lock.unlock();
    }

    public void flushit() {
        output_lock.lock();
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void blockChanged(int d, int x, int y, int z, int id, int meta) {
        if (this.connected == 0) {
            return;
        }
        int pt = 133;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        this.objectOutput.writeShort((short)id);
        this.objectOutput.writeShort((short)meta);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void respondtotime() {
        if (this.connected == 0) {
            return;
        }
        int pt = 129;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        pt = DangerZone.wr.fps;
        this.objectOutput.writeInt(pt);
        pt = DangerZone.renderdistance;
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void whatIsThisEntity(int id) {
        if (this.connected == 0) {
            return;
        }
        int pt = 137;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(id);
        output_lock.unlock();
    }

    public void sendKeyEventToEntity(int id, int key, boolean updown) {
        if (this.connected == 0) {
            return;
        }
        int pt = 171;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(id);
        this.objectOutput.writeInt(key);
        pt = updown ? 1 : 0;
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendMouseEventToEntity(int id, int key, boolean updown) {
        if (this.connected == 0) {
            return;
        }
        int pt = 172;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(id);
        this.objectOutput.writeInt(key);
        pt = updown ? 1 : 0;
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendBreakBlock(int d, int x, int y, int z, int s) {
        if (this.connected == 0) {
            return;
        }
        int pt = 176;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        this.objectOutput.writeInt(s);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendKillMe(int id) {
        if (this.connected == 0) {
            return;
        }
        int pt = 155;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(id);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendRespawn() {
        if (this.connected == 0) {
            return;
        }
        int pt = 174;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendPlayerDied() {
        if (this.connected == 0) {
            return;
        }
        int pt = 175;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendPlayerTeleport(int dim) {
        if (this.connected == 0) {
            return;
        }
        int pt = 159;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(dim);
        this.objectOutput.writeDouble(this.p.posx);
        this.objectOutput.writeDouble(this.p.posy);
        this.objectOutput.writeDouble(this.p.posz);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendLightResponse(float lv) {
        if (this.connected == 0) {
            return;
        }
        int pt = 152;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeFloat(lv);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendDisconnect() {
        if (this.connected == 0) {
            return;
        }
        int pt = 87;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        this.connected = 0;
        output_lock.unlock();
    }

    public void sendChatMessage(String s) {
        if (this.connected == 0) {
            return;
        }
        int pt = 153;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void idle() {
        if (this.connected == 0) {
            return;
        }
        int pt = 181;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendPetNameMessage(int eid, int slen, String s) {
        if (this.connected == 0) {
            return;
        }
        int pt = 160;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.objectOutput.writeInt(1);
        this.objectOutput.writeString(s);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendVarStringMessage(int eid, int which, String s) {
        if (this.connected == 0) {
            return;
        }
        int pt = 160;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeString(s);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendVarIntMessage(int eid, int which, int what) {
        if (this.connected == 0) {
            return;
        }
        int pt = 161;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeInt(what);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendCommandMessage(String s) {
        if (this.connected == 0) {
            return;
        }
        int pt = 156;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendSpawnParticles(String s, int hm, int d, double x, double y, double z) {
        this.sendSpawnParticles(s, hm, d, x, y, z, 0);
    }

    public void sendSpawnParticles(String s, int hm, int d, double x, double y, double z, int bid) {
        if (this.connected == 0) {
            return;
        }
        int pt = 154;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.writeInt(hm);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeDouble(x);
        this.objectOutput.writeDouble(y);
        this.objectOutput.writeDouble(z);
        this.objectOutput.writeInt(bid);
        output_lock.unlock();
    }

    public void sendSpawnParticlesScaled(String s, int hm, int d, double x, double y, double z, int bid, float scale) {
        if (this.connected == 0) {
            return;
        }
        int pt = 182;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.writeInt(hm);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeDouble(x);
        this.objectOutput.writeDouble(y);
        this.objectOutput.writeDouble(z);
        this.objectOutput.writeInt(bid);
        this.objectOutput.writeFloat(scale);
        output_lock.unlock();
    }

    public void sendSpawnParticlesScaledWithDirection(String s, int hm, int d, double x, double y, double z, float mx, float my, float mz, int bid, float scale, float vel, float randness) {
        if (this.connected == 0) {
            return;
        }
        int pt = 183;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.writeInt(hm);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeDouble(x);
        this.objectOutput.writeDouble(y);
        this.objectOutput.writeDouble(z);
        this.objectOutput.writeFloat(mx);
        this.objectOutput.writeFloat(my);
        this.objectOutput.writeFloat(mz);
        this.objectOutput.writeInt(bid);
        this.objectOutput.writeFloat(scale);
        this.objectOutput.writeFloat(vel);
        this.objectOutput.writeFloat(randness);
        output_lock.unlock();
    }

    public void playerActionToServer(int which, int what, int eid, int x, int y, int z, int side, float magic, int magic_type) {
        if (this.connected == 0) {
            return;
        }
        int pt = 148;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeInt(what);
        this.objectOutput.writeInt(eid);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        this.objectOutput.writeInt(side);
        this.objectOutput.writeFloat(magic);
        this.objectOutput.writeInt(magic_type);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void handleInventory(int command, int p1, int p2, int p3, int p4) {
        if (this.connected == 0) {
            return;
        }
        int pt = 178;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(command);
        this.objectOutput.writeInt(p1);
        this.objectOutput.writeInt(p2);
        this.objectOutput.writeInt(p3);
        this.objectOutput.writeInt(p4);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void changeGameMode(int which) {
        if (this.connected == 0) {
            return;
        }
        int pt = 166;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void changeGameDifficulty(int which) {
        if (this.connected == 0) {
            return;
        }
        int pt = 180;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void sendPlayerEntityUpdate(Entity e) {
        if (this.connected == 0) {
            return;
        }
        output_lock.lock();
        int pt = 144;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(e.entityID);
        this.objectOutput.writeInt(e.dimension);
        this.objectOutput.writeDouble(e.posx);
        this.objectOutput.writeDouble(e.posy);
        this.objectOutput.writeDouble(e.posz);
        this.objectOutput.writeFloat(e.motionx);
        this.objectOutput.writeFloat(e.motiony);
        this.objectOutput.writeFloat(e.motionz);
        this.objectOutput.writeFloat(e.rotation_pitch);
        this.objectOutput.writeFloat(360.0f - (e.rotation_yaw + 180.0f) % 360.0f);
        this.objectOutput.writeFloat(e.rotation_roll);
        this.objectOutput.writeFloat(e.rotation_pitch_head);
        this.objectOutput.writeFloat(360.0f - (e.rotation_yaw_head + 180.0f) % 360.0f);
        this.objectOutput.writeFloat(e.rotation_roll_head);
        this.objectOutput.writeFloat(e.rotation_pitch_motion);
        this.objectOutput.writeFloat(e.rotation_yaw_motion);
        this.objectOutput.writeFloat(e.rotation_roll_motion);
        if (e.deadflag) {
            pt = 1;
            this.objectOutput.writeInt(pt);
        } else {
            pt = 0;
            this.objectOutput.writeInt(pt);
        }
        this.objectOutput.writeInt(DangerZone.player.clienthotbarindex);
        pt = -3;
        this.objectOutput.writeInt(pt);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    private void receiveChunk(Chunk c) throws ClassNotFoundException {
        int nname = this.objectInput.readInt();
        if (nname > 0) {
            c.ownernames = new ArrayList<String>();
            while (nname > 0) {
                c.ownernames.add(this.objectInput.readString());
                --nname;
            }
        }
        c.chunkX = this.objectInput.readInt();
        c.chunkZ = this.objectInput.readInt();
        c.dimension = this.objectInput.readInt();
        c.isDecorated = this.objectInput.readInt();
        c.isChanged = this.objectInput.readInt();
        c.isValid = this.objectInput.readInt();
        c.must_be_written = this.objectInput.readInt();
        c.b_red = this.objectInput.readFloat();
        c.b_green = this.objectInput.readFloat();
        c.b_blue = this.objectInput.readFloat();
        int separator = this.objectInput.readInt();
        if (separator != -1) {
            System.out.printf("Big oops!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        while ((separator = (int)this.objectInput.readShort()) >= 0) {
            c.blockdata[separator] = new short[256];
            short curcount = this.objectInput.readShort();
            short curval = this.objectInput.readShort();
            int indx = 0;
            while (indx < 256) {
                c.blockdata[separator][indx] = (short)(curval & 0xFFFF);
                curcount = (short)(curcount - 1);
                if (indx < 255 && curcount == 0) {
                    curcount = this.objectInput.readShort();
                    curval = this.objectInput.readShort();
                }
                indx = (short)(indx + 1);
            }
        }
        while ((separator = (int)this.objectInput.readShort()) >= 0) {
            c.metadata[separator] = this.objectInput.readShortArray();
        }
    }

    private void readVarsIntoEntity(Entity ent) {
        int index = this.objectInput.readInt();
        if (index != -2) {
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_ints[index] = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_floats[index] = this.objectInput.readFloat();
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_strings[index] = this.objectInput.readString();
                }
                index = this.objectInput.readInt();
            }
            this.readChangedInventory(ent);
            index = this.objectInput.readInt();
        }
        if (index != -2) {
            System.out.printf("packet separator failure on enitity update!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        if ((index = this.objectInput.readInt()) > 0) {
            ArrayList<Effects> new_effect_list = new ArrayList<Effects>();
            while (index > 0) {
                Effects ef = new Effects();
                ef.effect = index;
                ef.amplitude = this.objectInput.readFloat();
                ef.duration = this.objectInput.readInt();
                ef.duration_counter = this.objectInput.readInt();
                new_effect_list.add(ef);
                index = this.objectInput.readInt();
            }
            ent.effect_list = new_effect_list;
        } else if (ent.effect_list.size() > 0) {
            ent.effect_list = new ArrayList<Effects>();
        }
        if (index != -3) {
            System.out.printf("packet terminator failure on enitity update!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void readChangedInventory(Entity ent) {
        int index = this.objectInput.readInt();
        String inmeta = null;
        while (index >= 0) {
            InventoryContainer ic;
            int count = this.objectInput.readInt();
            if (count <= 0) {
                ic = null;
            } else {
                int mlength;
                int atcount;
                int bid = this.objectInput.readInt();
                int iid = this.objectInput.readInt();
                int uses = this.objectInput.readInt();
                inmeta = this.objectInput.readString();
                ic = new InventoryContainer();
                ic.bid = bid;
                ic.iid = iid;
                ic.count = count;
                ic.currentuses = uses;
                ic.icmeta = inmeta;
                if (ic.count == 1 && ic.bid == 0 && ic.iid != 0 && (atcount = this.objectInput.readInt()) > 0) {
                    int i = 0;
                    while (i < atcount) {
                        int attype = this.objectInput.readInt();
                        int atval = this.objectInput.readInt();
                        ic.addAttribute(attype, atval);
                        ++i;
                    }
                }
                if ((mlength = this.objectInput.readInt()) > 0) {
                    ic.moreInventory = new InventoryContainer[mlength];
                    int mix = 0;
                    while (mix < mlength) {
                        int mindx = this.objectInput.readInt();
                        ic.moreInventory[mindx] = this.readMoreInventory();
                        ++mix;
                    }
                }
            }
            ent.setVarInventory(index, ic);
            index = this.objectInput.readInt();
        }
    }

    public InventoryContainer readMoreInventory() {
        int mlength;
        int atcount;
        int count = this.objectInput.readInt();
        if (count <= 0) {
            return null;
        }
        int bid = this.objectInput.readInt();
        int iid = this.objectInput.readInt();
        int uses = this.objectInput.readInt();
        String inmeta = this.objectInput.readString();
        InventoryContainer ic = new InventoryContainer();
        ic.bid = bid;
        ic.iid = iid;
        ic.count = count;
        ic.currentuses = uses;
        ic.icmeta = inmeta;
        if (ic.count == 1 && ic.bid == 0 && ic.iid != 0 && (atcount = this.objectInput.readInt()) > 0) {
            int i = 0;
            while (i < atcount) {
                int attype = this.objectInput.readInt();
                int atval = this.objectInput.readInt();
                ic.addAttribute(attype, atval);
                ++i;
            }
        }
        if ((mlength = this.objectInput.readInt()) > 0) {
            ic.moreInventory = new InventoryContainer[mlength];
            int mix = 0;
            while (mix < mlength) {
                int mindx = this.objectInput.readInt();
                ic.moreInventory[mindx] = this.readMoreInventory();
                ++mix;
            }
        } else {
            ic.moreInventory = null;
        }
        return ic;
    }

    private void readVarsIntoNull() {
        int index = 0;
        index = this.objectInput.readInt();
        if (index != -2) {
            while (index >= 0) {
                this.objectInput.readInt();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                this.objectInput.readFloat();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                this.objectInput.readString();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                int count = this.objectInput.readInt();
                if (count > 0) {
                    int mlength;
                    int atcount;
                    int bid = this.objectInput.readInt();
                    int iid = this.objectInput.readInt();
                    this.objectInput.readInt();
                    this.objectInput.readString();
                    if (count == 1 && bid == 0 && iid != 0 && (atcount = this.objectInput.readInt()) > 0) {
                        int i = 0;
                        while (i < atcount) {
                            this.objectInput.readInt();
                            this.objectInput.readInt();
                            ++i;
                        }
                    }
                    if ((mlength = this.objectInput.readInt()) > 0) {
                        int mix = 0;
                        while (mix < mlength) {
                            this.objectInput.readInt();
                            this.readMoreInventory();
                            ++mix;
                        }
                    }
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
        }
        if (index != -2) {
            System.out.printf("packet separator failure on enititynull update!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        if ((index = this.objectInput.readInt()) > 0) {
            while (index > 0) {
                this.objectInput.readFloat();
                this.objectInput.readInt();
                this.objectInput.readInt();
                index = this.objectInput.readInt();
            }
        }
        if (index != -3) {
            System.out.printf("packet terminator failure on enititynull update!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendSound(String name, int dimension, double posx, double posy, double posz, float volume, float frequency) {
        if (this.connected == 0) {
            return;
        }
        output_lock.lock();
        int pt = 150;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(name);
        this.objectOutput.writeInt(dimension);
        this.objectOutput.writeDouble(posx);
        this.objectOutput.writeDouble(posy);
        this.objectOutput.writeDouble(posz);
        this.objectOutput.writeFloat(volume);
        this.objectOutput.writeFloat(frequency);
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void reSyncIDs() {
        String name = null;
        int i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            Items.reRegisterItemAt(name, i);
            i = this.objectInput.readInt();
        }
        i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            Blocks.reRegisterBlockAt(name, i);
            i = this.objectInput.readInt();
        }
        i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            Dimensions.reRegisterDimensionAt(name, i);
            i = this.objectInput.readInt();
        }
        i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            CustomPackets.reRegisterCustomPacketAt(name, i);
            i = this.objectInput.readInt();
        }
        i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            int x = this.objectInput.readInt();
            float[][][] colordata = new float[16][16][4];
            int m = 0;
            while (m < 16) {
                int j = 0;
                while (j < 16) {
                    int k = 0;
                    while (k < 4) {
                        colordata[m][j][k] = this.objectInput.readFloat();
                        ++k;
                    }
                    ++j;
                }
                ++m;
            }
            this.doSaveColoringBlock(name, x, colordata);
            i = this.objectInput.readInt();
        }
    }

    public void getModNames() {
        String name = null;
        int i = this.objectInput.readInt();
        while (i > 0) {
            name = this.objectInput.readString();
            this.modnames.add(name);
            --i;
        }
        this.worldname = this.objectInput.readString();
    }

    private void sendSkin() {
        int pt = -3;
        byte[] b = this.p.tdata;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeByteArray(b, b.length);
        this.objectOutput.flush();
    }

    private void getSkinData(Entity e) {
        Player pe = (Player)e;
        byte[] b = this.objectInput.readByteArray();
        if (b == null || b.length < 8192) {
            return;
        }
        pe.tdata = b;
        pe.donewtexture = true;
    }

    public NetworkOutputBuffer getOutputStream() {
        if (this.connected == 0) {
            return null;
        }
        if (DangerZone.gameover != 0) {
            return null;
        }
        output_lock.lock();
        return this.objectOutput;
    }

    public void releaseOutputStream() {
        output_lock.unlock();
    }

    private void readPlayerIntoPlayer(Player ent) {
        ent.dimension = this.objectInput.readInt();
        ent.posx = this.objectInput.readDouble();
        ent.posy = this.objectInput.readDouble();
        ent.posz = this.objectInput.readDouble();
        ent.motionx = this.objectInput.readFloat();
        ent.motiony = this.objectInput.readFloat();
        ent.motionz = this.objectInput.readFloat();
        ent.rotation_pitch = this.objectInput.readFloat();
        ent.rotation_yaw = this.objectInput.readFloat();
        ent.rotation_roll = this.objectInput.readFloat();
        ent.rotation_pitch_head = this.objectInput.readFloat();
        ent.rotation_yaw_head = this.objectInput.readFloat();
        ent.rotation_roll_head = this.objectInput.readFloat();
        ent.rotation_pitch_motion = this.objectInput.readFloat();
        ent.rotation_yaw_motion = this.objectInput.readFloat();
        ent.rotation_roll_motion = this.objectInput.readFloat();
        int dead = this.objectInput.readInt();
        ent.deadflag = dead != 0;
        this.readVarsIntoEntity(ent);
        ent.stray_entity_ticker = 0;
        ent.rotation_yaw = 360.0f - (ent.rotation_yaw + 180.0f) % 360.0f;
        ent.rotation_yaw_head = 360.0f - (ent.rotation_yaw_head + 180.0f) % 360.0f;
    }

    public void sendColoringBlock(int bid, int dim, int x, int y, int z, float[][][] colordata) {
        if (this.connected == 0) {
            return;
        }
        int pt = 164;
        output_lock.lock();
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(bid);
        this.objectOutput.writeInt(dim);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int k = 0;
                while (k < 4) {
                    this.objectOutput.writeFloat(colordata[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.objectOutput.flush();
        output_lock.unlock();
    }

    public void doSaveColoringBlock(String blkname, int bid, float[][][] colordata) {
        File file = null;
        if (bid < 0 || bid >= 2048) {
            return;
        }
        if (DangerZone.start_server) {
            Block blk = Blocks.BlockArray[bid];
            blk.texture = null;
            blk.stitchedtexture = new StitchedTexture();
            return;
        }
        try {
            file = File.createTempFile("colordata", ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        file.deleteOnExit();
        int width = 16;
        int height = 16;
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 1);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int r = (int)colordata[x][y][0] & 0xFF;
                int g = (int)colordata[x][y][1] & 0xFF;
                int b = (int)colordata[x][y][2] & 0xFF;
                image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                ++y;
            }
            ++x;
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image.flush();
        if (Blocks.BlockArray[bid] != null) {
            Block blk = Blocks.BlockArray[bid];
            blk.texturepath = file.getAbsolutePath();
            blk.texture = null;
            blk.stitchedtexture = new StitchedTexture();
        } else {
            ColoringBlock cb = new ColoringBlock(blkname, "");
            cb.texturepath = file.getAbsolutePath();
            cb.blockID = bid;
            Blocks.BlockArray[bid] = cb;
        }
    }

    float angdiff(float a1, float a2) {
        while (a1 > 360.0f) {
            a1 -= 360.0f;
        }
        while (a2 > 360.0f) {
            a2 -= 360.0f;
        }
        while (a1 < 0.0f) {
            a1 += 360.0f;
        }
        while (a2 < 0.0f) {
            a2 += 360.0f;
        }
        float retval = a1 - a2;
        if (retval < 0.0f) {
            retval += 360.0f;
        }
        if (retval > 180.0f) {
            retval -= 360.0f;
        }
        return retval;
    }
}

